/*
 * Decompiled with CFR 0.152.
 */
package net.firemuffin303.thaidelight.common.entity;

import net.firemuffin303.thaidelight.common.block.CrabEggBlock;
import net.firemuffin303.thaidelight.common.registry.ModBlocks;
import net.firemuffin303.thaidelight.common.registry.ModEntityTypes;
import net.firemuffin303.thaidelight.common.registry.ModItems;
import net.firemuffin303.thaidelight.common.registry.ModTags;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class FlowerCrabEntity
extends Animal
implements Bucketable {
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.m_135353_(FlowerCrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Ingredient FOOD_ITEMS;
    private static final EntityDataAccessor<Boolean> LAYING_EGG;
    private static final EntityDataAccessor<Boolean> FROM_BUCKET;
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState danceAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    int layEggCounter;
    @Nullable
    private BlockPos jukebox;

    public FlowerCrabEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("HasEgg", this.hasEgg());
        compoundTag.m_128379_("FromBucket", this.m_27487_());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setHasEgg(compoundTag.m_128471_("HasEgg"));
        this.m_27497_(compoundTag.m_128471_("FromBucket"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_EGG, (Object)false);
        this.f_19804_.m_135372_(LAYING_EGG, (Object)false);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(1, (Goal)new CrabBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new CrabLayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        return Bucketable.m_148828_((Player)player, (InteractionHand)interactionHand, (LivingEntity)this).orElse(super.m_6071_(player, interactionHand));
    }

    public boolean m_6898_(ItemStack arg) {
        return FOOD_ITEMS.test(arg);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    public void m_8107_() {
        if (this.jukebox == null || !this.jukebox.m_203195_((Position)this.m_20182_(), 3.46) || !this.m_9236_().m_8055_(this.jukebox).m_60713_(Blocks.f_50131_)) {
            this.jukebox = null;
            this.danceAnimationState.m_216973_();
        }
        super.m_8107_();
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 40;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    public void m_6818_(BlockPos blockPos, boolean bl) {
        this.jukebox = blockPos;
        if (blockPos != null && bl) {
            this.danceAnimationState.m_216982_(this.f_19797_);
        } else {
            this.danceAnimationState.m_216973_();
        }
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean hasEgg() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGG);
    }

    void setHasEgg(boolean bl) {
        this.f_19804_.m_135381_(HAS_EGG, (Object)bl);
    }

    public boolean isLayingEgg() {
        return (Boolean)this.f_19804_.m_135370_(LAYING_EGG);
    }

    void setLayingEgg(boolean bl) {
        this.layEggCounter = bl ? 1 : 0;
        this.f_19804_.m_135381_(LAYING_EGG, (Object)bl);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)ModEntityTypes.FLOWER_CRAB.m_20615_((Level)serverLevel);
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean bl) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)bl);
    }

    public void m_6872_(ItemStack arg) {
        Bucketable.m_148822_((Mob)this, (ItemStack)arg);
        CompoundTag compoundTag = arg.m_41784_();
        compoundTag.m_128405_("Age", this.m_146764_());
    }

    public void m_142278_(CompoundTag arg) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)arg);
        if (arg.m_128441_("Age")) {
            this.m_146762_(arg.m_128451_("Age"));
        }
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)ModItems.CRAB_BUCKET);
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11779_;
    }

    public static boolean checkSpawnRules(EntityType<FlowerCrabEntity> crabEntityEntityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return serverLevelAccessor.m_8055_(blockPos.m_7495_()).m_204336_(BlockTags.f_215827_) && FlowerCrabEntity.m_186209_((BlockAndTintGetter)serverLevelAccessor, (BlockPos)blockPos);
    }

    static {
        LAYING_EGG = SynchedEntityData.m_135353_(FlowerCrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        FOOD_ITEMS = Ingredient.m_204132_(ModTags.FLOWER_CRAB_FOOD);
        FROM_BUCKET = SynchedEntityData.m_135353_(FlowerCrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }

    private static class CrabBreedGoal
    extends BreedGoal {
        private final FlowerCrabEntity crab;

        public CrabBreedGoal(FlowerCrabEntity crabEntity, double d) {
            super((Animal)crabEntity, d);
            this.crab = crabEntity;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.crab.hasEgg();
        }

        protected void m_8026_() {
            ServerPlayer serverPlayer = this.f_25113_.m_27592_();
            if (serverPlayer == null && this.f_25115_.m_27592_() != null) {
                serverPlayer = this.f_25115_.m_27592_();
            }
            if (serverPlayer != null) {
                serverPlayer.m_36220_(Stats.f_12937_);
                CriteriaTriggers.f_10581_.m_147278_(serverPlayer, this.f_25113_, this.f_25115_, (AgeableMob)null);
            }
            this.crab.setHasEgg(true);
            this.f_25113_.m_146762_(6000);
            this.f_25115_.m_146762_(6000);
            this.f_25113_.m_27594_();
            this.f_25115_.m_27594_();
            RandomSource randomSource = this.f_25113_.m_217043_();
            if (this.f_25114_.m_46469_().m_46207_(GameRules.f_46135_)) {
                this.f_25114_.m_7967_((Entity)new ExperienceOrb(this.f_25114_, this.f_25113_.m_20185_(), this.f_25113_.m_20186_(), this.f_25113_.m_20189_(), randomSource.m_188503_(7) + 1));
            }
        }
    }

    static class CrabLayEggGoal
    extends MoveToBlockGoal {
        private final FlowerCrabEntity crab;

        CrabLayEggGoal(FlowerCrabEntity crab, double d) {
            super((PathfinderMob)crab, d, 16);
            this.crab = crab;
        }

        public boolean m_8036_() {
            return this.crab.hasEgg() && super.m_8036_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.crab.hasEgg();
        }

        public void m_8037_() {
            super.m_8037_();
            BlockPos blockPos = this.crab.m_20183_();
            if (this.crab.m_20069_() && this.m_25625_()) {
                if (this.crab.layEggCounter < 1) {
                    this.crab.setLayingEgg(true);
                } else if (this.crab.layEggCounter > this.m_183277_(200)) {
                    Level level = this.crab.m_9236_();
                    level.m_5594_((Player)null, blockPos, SoundEvents.f_12486_, SoundSource.BLOCKS, 0.3f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
                    BlockPos blockPos2 = this.f_25602_.m_7494_();
                    FluidState fluidState = level.m_6425_(blockPos2);
                    BlockState blockState = (BlockState)ModBlocks.CRAB_EGG.m_49966_().m_61124_((Property)CrabEggBlock.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_192917_((Fluid)Fluids.f_76193_)));
                    level.m_7731_(blockPos2, blockState, 3);
                    level.m_220407_(GameEvent.f_157797_, blockPos2, GameEvent.Context.m_223719_((Entity)this.crab, (BlockState)blockState));
                    this.crab.setHasEgg(false);
                    this.crab.setLayingEgg(false);
                    this.crab.m_27601_(600);
                }
                if (this.crab.isLayingEgg()) {
                    ++this.crab.layEggCounter;
                }
            }
        }

        protected boolean m_6465_(LevelReader levelReader, BlockPos blockPos) {
            return levelReader.m_46801_(blockPos.m_7494_());
        }
    }
}

